%-------------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      Simulate4_Sub.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
% Class:          PSYCH221
% Description:    Called by Simulate3_Main to run each of the iterations
%-------------------------------------------------------------------------------

close all; clc;
NumRuns = 100;

% Note, this file assumes that there is already a SensorData4.mat file which
% contains all the different sensor parameters that are to be simulated

disp('Running project for 4 color sensor:');
disp('--------------------------------------');

% Define the number of sensors
numSensors = 4;

% Define Analysis Types
kMacBethAnalysis = 1;
kMTFAnalysis = 2;

% Repeat this for the Macbeth and Slanted bar scenes
while(analysisIndex <= kMTFAnalysis)
      
  % Reset the state of the random number generator
  rand('state',0)

  % Initialize the project settings
  InitializeProject;
 
  % Define the Scene
  switch analysisIndex
     case {kMacBethAnalysis}
        disp('Analyzing Color Accuracy');
        DefineMacBethScene;
    case {kMTFAnalysis}
        disp('Analyzing MTF');
        DefineMTFScene;
     otherwise
        disp('Unknown scene');
  end

  % Define the Optics
  DefineOptics;
  
  % Load in the sensor settings
  load SensorData4.mat;
  NumSimulations = size(sensorSettings,1);
  
  % Store the names of the columns in the results array so that we can
  % interpret the data
  ResultNames = sensorSettings_Names;
  
  save('Simulate4Data.mat','oi','scene','analysisIndex', 'numSensors', ...
       'kMacBethAnalysis', 'kMTFAnalysis', 'NumSimulations', 'NumRuns');  
  
  % Run through all the different sensor settings
  while(sensorIndex <= NumSimulations)
      InitializeProject;
      vcReplaceAndSelectObject(scene);
      vcReplaceAndSelectObject(oi);
      
      % Create the Image Sensor
      sensorPos = sensorSettings(sensorIndex,numSensors+1:end);
      sensorWidth = sensorSettings(sensorIndex,1:numSensors);
      CreateSensorGauss;

      % Perform Post-Processing
      ProcessImage;
      
      % Clear the screen
      clc;
      
      % Perform Analysis of Data Collected
      switch analysisIndex
         case {kMacBethAnalysis}
            MacBethAnalysis;
            colorMetrics(sensorIndex) = deltaE_avg;
            noiseMetrics(sensorIndex) = yNoise_avg;
            disp(sprintf('%d Color MacbethAnalysis: %d of %d',numSensors,sensorIndex,NumSimulations));
      	 case {kMTFAnalysis}
            MTFAnalysis;
            frequencyMetrics(sensorIndex) = results.mtf50;
            disp(sprintf('%d Color MTFAnalysis: %d of %d',numSensors,sensorIndex,NumSimulations));
          otherwise
            disp('Unknown analysis');
      end 

      
      if (mod(sensorIndex, NumRuns) == 0),
          % Clear everything and start fresh
          save('SavedData4.mat', 'colorMetrics','noiseMetrics','frequencyMetrics','analysisIndex');
          save('Simulate4_sensorIndex.mat', 'sensorIndex');

          close all;    clear all;
          load Simulate4Data.mat;
          load Simulate4_sensorIndex.mat;
          load SavedData4;
          load SensorData4.mat;
      end
      
      sensorIndex = sensorIndex + 1;
  end
  
  disp('---------------------------------------------------------------------')
   
  sensorIndex = 1;
  analysisIndex = analysisIndex + 1;
end

% End of File
